package zigen.plugin.db.ext.jdt.ui.popup.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

import zigen.plugin.db.core.ClipboardUtils;

public class CompilationUnitEditorContextAction implements IEditorActionDelegate {
	
	private ISelection selection;
	
	private IEditorPart editorPart;
	
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		this.editorPart = targetEditor;
	}
	
	
	public void run(IAction action) {
		
		// IJavaElement javaElement = JavaUI.getEditorInputJavaElement(zigen.plugin.db.ext.jdt.Activator.getDefault().getPage().getActiveEditor().getEditorInput());
		// System.out.println(javaElement.getClass().getName());
		// if (javaElement instanceof ICompilationUnit) {
		// ICompilationUnit cu = (ICompilationUnit) javaElement;
		// if (selection instanceof ITextSelection) {
		// ITextSelection textSelection = (ITextSelection) selection;
		// String text = textSelection.getText();
		// int offset = textSelection.getOffset();
		// try {
		// IJavaElement elem = cu.getElementAt(offset);
		// System.out.println("J[\ʒuɂ郁\bh F " + elem.getElementName());
		// } catch (JavaModelException e) {
		// e.printStackTrace();
		// }
		// }
		// }
		
		Clipboard clipboard = ClipboardUtils.getInstance();
		TextTransfer text_transfer = TextTransfer.getInstance();
		
		if (selection instanceof ITextSelection) {
			ITextSelection textSelection = (ITextSelection) selection;
			
			int offset = textSelection.getOffset();
			
			// System.out.println("offset = " + offset);
			// System.out.println("startLine = " + textSelection.getStartLine());
			
			String text = textSelection.getText();
			if (text.length() > 0) {
				String str1 = text.replaceAll("^(.|[\r\n])*?\"|\"[^\"]*$|\"(.|[\r\n])+?\"", "");
				// sR[h͍폜
				// System.out.println(">>" + str1);
				String str2 = str1.replaceAll("\\\\r\\\\n|\\\\r|\\\\n", "");
				// System.out.println(">>" + str2);
				clipboard.setContents(new Object[] {str2}, new Transfer[] {text_transfer});
			}
		}
		
	}
	
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}
}
